local t = Def.ActorFrame{};
local MeterFillHeight = 400
local loadLife = GAMESTATE:GetCurrentStyle():GetStyleType() == 'StyleType_OnePlayerTwoSides' and "_DtexLife" or "_texLife"

local function LifeMeterLength()
	local Style = GAMESTATE:GetCurrentStyle():GetStyleType()
	local sName = GAMESTATE:GetCurrentStyle():GetName()
	local Techno = GAMESTATE:GetCurrentGame():GetName() == "techno"
	local LifeLength = 0
	
	if Techno or sName == "solo" or sName == "double" then
		LifeLength = Width()
	elseif Style == 'StyleType_OnePlayerOneSide' then
		LifeLength = 392
	elseif Style == 'StyleType_TwoPlayersTwoSides' then
		LifeLength = Width()/2
	end
	return LifeLength
end

local function hAlign(pn)
	local Style = GAMESTATE:GetCurrentStyle():GetStyleType()
	local sName = GAMESTATE:GetCurrentStyle():GetName()
	local Techno = GAMESTATE:GetCurrentGame():GetName() == "techno"
	local hA = 0
	
	if pn == PLAYER_1 then
		if Techno or sName == "solo" or sName == "double" then
			hA = 0.5
		elseif Style == 'StyleType_OnePlayerOneSide' or Style == 'StyleType_TwoPlayersTwoSides' then
			hA = 0
		end
	end
	if pn == PLAYER_2 then
		if Techno or sName == "solo" or sName == "double" then
			hA = 0.5
		elseif Style == 'StyleType_OnePlayerOneSide' or Style == 'StyleType_TwoPlayersTwoSides' then
			hA = 1
		end
	end
	return hA
end

if IsPlayerEnabled(PLAYER_1) then
	t[#t+1] = Def.ActorFrame{
		Def.Quad{
			Name="LifeMeterUnderP1";
			InitCommand=cmd(visible,LifeVisible(PLAYER_1);diffuse,Black();zoomto,LifeMeterLength(),0;align,hAlign(PLAYER_1),1);
			OnCommand=cmd(xy,SurroundLifeP1X(),Bottom()-40);
			LifeChangedMessageCommand=function(self,params)
				if (params.Player == PLAYER_1) then
					local life = params.LifeMeter:GetLife() * (MeterFillHeight);
					self:zoomy(life);
				end;
			end;
		};
		LoadActor(loadLife)..{
			InitCommand=cmd(visible,LifeVisible(PLAYER_1);diffuseshift;effectperiod,2;effectcolor1,Yellow();effectcolor2,Red();zoomto,LifeMeterLength(),0;align,hAlign(PLAYER_1),1);
			OnCommand=cmd(xy,SurroundLifeP1X(),Bottom()-40);
			HealthStateChangedMessageCommand=function(self,params)
				if(params.PlayerNumber == PLAYER_1) then
					if(params.HealthState ~= 'HealthState_Hot') then
						self:visible(true)
					else
						self:visible(false)
					end
				end
			end;
			LifeChangedMessageCommand=function(self,params)
				if (params.Player == PLAYER_1) then
					local life = params.LifeMeter:GetLife() * (MeterFillHeight);
					self:zoomy(life/4);
				end;
			end;
		};
		Def.Quad{
			Name="LifeMeterOverP1";
			InitCommand=cmd(visible,LifeVisible(PLAYER_1);diffuse,Black();zoomto,LifeMeterLength(),0;align,hAlign(PLAYER_1),1);
			OnCommand=cmd(xy,SurroundLifeP1X(),Bottom()+360);
			LifeChangedMessageCommand=function(self,params)
				if (params.Player == PLAYER_1) then
					local life = params.LifeMeter:GetLife() * (MeterFillHeight);
					self:zoomy(life);
				end;
			end;
		};
		LoadActor(loadLife)..{
			InitCommand=cmd(visible,LifeVisible(PLAYER_1);diffuseshift;effectperiod,2;effectcolor1,color("#0090CC");effectcolor2,color("#00CC90");zoomto,LifeMeterLength(),0;align,hAlign(PLAYER_1),1);
			OnCommand=cmd(xy,SurroundLifeP1X(),Bottom()+360);
			HealthStateChangedMessageCommand=function(self,params)
				if(params.PlayerNumber == PLAYER_1) then
					if(params.HealthState ~= 'HealthState_Hot') then
						self:visible(true)
					else
						self:visible(false)
					end
				end
			end;
			LifeChangedMessageCommand=function(self,params)
				if (params.Player == PLAYER_1) then
					local life = params.LifeMeter:GetLife() * (MeterFillHeight);
					self:zoomy(life/4);
				end;
			end;
		};
		LoadActor(loadLife)..{
			InitCommand=cmd(visible,LifeVisible(PLAYER_1);diffuse,color("#711AFF");zoomto,LifeMeterLength(),0;align,hAlign(PLAYER_1),1);
			OnCommand=cmd(xy,SurroundLifeP1X(),Bottom()+360);
			HealthStateChangedMessageCommand=function(self,params)
				if(params.PlayerNumber == PLAYER_1) then
					if(params.HealthState == 'HealthState_Hot') then
						self:visible(true)
					else
						self:visible(false)
					end
				end
			end;
			LifeChangedMessageCommand=function(self,params)
				if (params.Player == PLAYER_1) then
					local life = params.LifeMeter:GetLife() * (MeterFillHeight);
					self:zoomy(life/4);
				end;
			end;
		};
	};
end

if IsPlayerEnabled(PLAYER_2) then
	t[#t+1] = Def.ActorFrame{
		Def.Quad{
			Name="LifeMeterUnderP2";
			InitCommand=cmd(visible,LifeVisible(PLAYER_2);diffuse,Black();zoomto,LifeMeterLength(),0;align,hAlign(PLAYER_2),1);
			OnCommand=cmd(xy,SurroundLifeP2X(),Bottom()-40);
			LifeChangedMessageCommand=function(self,params)
				if (params.Player == PLAYER_2) then
					local life = params.LifeMeter:GetLife() * (MeterFillHeight);
					self:zoomy(life);
				end;
			end;
		};
		LoadActor(loadLife)..{
			InitCommand=cmd(visible,LifeVisible(PLAYER_2);diffuseshift;effectperiod,2;effectcolor1,Yellow();effectcolor2,Red();zoomto,LifeMeterLength(),0;align,hAlign(PLAYER_2),1);
			OnCommand=cmd(xy,SurroundLifeP2X(),Bottom()-40);
			HealthStateChangedMessageCommand=function(self,params)
				if(params.PlayerNumber == PLAYER_2) then
					if(params.HealthState ~= 'HealthState_Hot') then
						self:visible(true)
					else
						self:visible(false)
					end
				end
			end;
			LifeChangedMessageCommand=function(self,params)
				if (params.Player == PLAYER_2) then
					local life = params.LifeMeter:GetLife() * (MeterFillHeight);
					self:zoomy(life/4);
				end;
			end;
		};
		Def.Quad{
			Name="LifeMeterOverP2";
			InitCommand=cmd(visible,LifeVisible(PLAYER_2);diffuse,Black();zoomto,LifeMeterLength(),0;align,hAlign(PLAYER_2),1);
			OnCommand=cmd(xy,SurroundLifeP2X(),Bottom()+360);
			LifeChangedMessageCommand=function(self,params)
				if (params.Player == PLAYER_2) then
					local life = params.LifeMeter:GetLife() * (MeterFillHeight);
					self:zoomy(life);
				end;
			end;
		};
		LoadActor(loadLife)..{
			InitCommand=cmd(visible,LifeVisible(PLAYER_2);diffuseshift;effectperiod,2;effectcolor1,color("#0090CC");effectcolor2,color("#00CC90");zoomto,LifeMeterLength(),0;align,hAlign(PLAYER_2),1);
			OnCommand=cmd(xy,SurroundLifeP2X(),Bottom()+360);
			HealthStateChangedMessageCommand=function(self,params)
				if(params.PlayerNumber == PLAYER_2) then
					if(params.HealthState ~= 'HealthState_Hot') then
						self:visible(true)
					else
						self:visible(false)
					end
				end
			end;
			LifeChangedMessageCommand=function(self,params)
				if (params.Player == PLAYER_2) then
					local life = params.LifeMeter:GetLife() * (MeterFillHeight);
					self:zoomy(life/4);
				end;
			end;
		};
		LoadActor(loadLife)..{
			InitCommand=cmd(visible,LifeVisible(PLAYER_2);diffuse,color("#711AFF");zoomto,LifeMeterLength(),0;align,hAlign(PLAYER_2),1);
			OnCommand=cmd(xy,SurroundLifeP2X(),Bottom()+360);
			HealthStateChangedMessageCommand=function(self,params)
				if(params.PlayerNumber == PLAYER_2) then
					if(params.HealthState == 'HealthState_Hot') then
						self:visible(true)
					else
						self:visible(false)
					end
				end
			end;
			LifeChangedMessageCommand=function(self,params)
				if (params.Player == PLAYER_2) then
					local life = params.LifeMeter:GetLife() * (MeterFillHeight);
					self:zoomy(life/4);
				end;
			end;
		};
	};
end

return t